#include "vertex.h"

Vertex::Vertex() {}

Vertex::Vertex(const QVector3D& pos, const QVector3D& normal, const QVector2D& tex) {
    this->pos    = pos;
    this->tex    = tex;
    this->normal = normal;
}

bool Vertex::samePos(const Vertex& other) const {
    return pos == other.pos;
}

QDebug operator<< (QDebug d, const Vertex &v) {
    d.nospace() << "Vertex(" << v.pos << ", " << v.normal << ", " << v.tex << ")";
    d.space();
    return d;
}
