#version 430
#define ALPHA 0.15

layout(location = 0) out vec4 color;


in vec3 gCamPosition;
in vec3 gCamNormal;
in vec3 gTriDistance;
in vec3 gPatchDistance;

uniform bool wireframe;

uniform sampler2D colorTexture;
uniform vec3 LightPos;

struct Material
{
    vec3 Diffuse;
    vec3 Specular;
    float Shininess;
    bool hasTexture;
};

uniform Material materialInfo;

vec3 phong(vec3 lightPos){
    vec3 dcolor = materialInfo.Diffuse;

    vec3 V = normalize(-gCamPosition);
    vec3 N = normalize(gCamNormal);
    vec3 L = normalize(lightPos-gCamPosition);
    vec3 R = normalize(reflect(-L,N));

    float diffuse = max(dot(L,N),0.0);
    diffuse = abs(dot(L,N));


    float specular = pow(max(dot(R,V),0.0),materialInfo.Shininess);

    //return vec3(diffuse );
    //return dcolor;
    //return (diffuse*dcolor);
    return (dcolor * diffuse );//+ materialInfo.Specular * specular);

}


void amplify(float d, vec4 newColor, float scale){
    d = scale*d;
    d = clamp(exp2(-2*d*d),0,1);
    color = newColor*d+(1-d)*color;
}

void addWireframe(){
    //Wireframe rendering
    if( wireframe == true){
        float d = min(gTriDistance.x,min(gTriDistance.y,gTriDistance.z));
        amplify(d, vec4(0.0,1.0,0.0,ALPHA),30);

        float d2 = min(gPatchDistance.x,min(gPatchDistance.y,gPatchDistance.z));
        amplify(d2, vec4(0.0,0.0,1.0,ALPHA),40);
    }
}



void main()
{
    color = vec4(phong(LightPos),ALPHA);
    //color = abs(normalize(gCamNormal));

    addWireframe();

    // color = vec4(materialInfo.Diffuse,0);
    //    color = normalize(abs(vec3(gCamPosition.x,gCamPosition.y,0.0)));

}
