#pragma once
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <mainwidget.h>
#include <mesh.h>
#include "camera.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void sliderfix(int pos);
    void subdivChange(int change);

private:
    int oldSliderpos = 0;
    MainWidget *m_centralWidget;

    QToolBar *toolBar;
    QAction *loadMesh;
    QAction *switchRotation;
    QAction *switchWireframe;
    QAction *CamHome;
    QAction *debugOutput;
    QSlider *subdivSlider;

};

#endif // MAINWINDOW_H
