#include "camera.h"

Camera::Camera()
{
    //setHome(new QQuaternion(45,0,1,0), new QVector3D(-100,0,0));
    setHome(new QQuaternion(QQuaternion::fromAxisAndAngle(1,0,0,20)), new QVector3D(0,0,-150));
}

void Camera::home()
{
    this->rotation = homeRotation;
    this->translation = homeTranslation;

}

void Camera::setHome(QQuaternion *rotation, QVector3D *translation){
    this->homeRotation = rotation;
    this->homeTranslation = translation;
    home();
}
void Camera::rotate(QQuaternion newPos ){
    QQuaternion newRot = newPos * *rotation;
    rotation = new QQuaternion(newRot.toVector4D());
}

void Camera::move(QVector3D newPos ){
    QVector3D newTrans = newPos + *translation;
    translation = new QVector3D(newTrans);
}

QMatrix4x4 Camera::getMatrix(){
    QMatrix4x4 mat = QMatrix4x4();
    mat.translate(*translation);
    mat.rotate(*rotation);
    return mat;
}
