#version 330
layout(location = 0) out vec3 color;


in vec3 vCamPosition;
in vec3 vCamNormal;
in vec2 vUV;
in vec4 debugout;


uniform sampler2D colorTexture;
uniform vec3 LightPos;

struct Material
{
    vec3 Diffuse;
    vec3 Specular;
    float Shininess;
    bool hasTexture;
};

uniform Material materialInfo;

vec3 phong(vec3 lightPos){
    vec3 dcolor = materialInfo.Diffuse;
    if(materialInfo.hasTexture){
        dcolor = texture2D(colorTexture,vUV).xyz;
    }
    vec3 V = normalize(-vCamPosition);
    vec3 N = normalize(vCamNormal);
    vec3 L = normalize(lightPos-vCamPosition);
    vec3 R = normalize(reflect(-L,N));

    float diffuse = max(dot(L,N),0.0);
    float specular = pow(max(dot(R,V),0.0),materialInfo.Shininess);

    //return (color * specular);
    //return (color * diffuse);
    return (dcolor * diffuse+ materialInfo.Specular * specular);
}

void main(void)
{
    color = phong(LightPos);
    //color = debugout.xyz;
    //color = vec3(1.0,0.0,0.0);
    //color = texture2D(colorTexture,vUV).xyz;
    //color = vec3(vUV,0.0);
}

