#pragma once
#ifndef VERTEX_H

#include <QDebug>
#include <QVector2D>
#include <QVector3D>

#pragma pack(push, 1)
struct Vertex
{
    QVector3D pos;
    float padding0;

    QVector3D normal;
    float padding1;

    QVector2D tex;
    float padding2[2];

    Vertex();
    Vertex(const QVector3D& pos, const QVector3D& normal, const QVector2D& tex);

    bool samePos(const Vertex& other) const;
};
#pragma pack(pop)

QDebug operator<< (QDebug d, const Vertex &v);

#endif
