#pragma once
#ifndef TRIANGLE_H
#define TRIANGLE_H

#include <QDebug>
#include <QVector>
#include "vertex.h"

class Triangle {
    public:
        struct Edge {
            enum Name {
                uv,
                vw,
                wu
            };

            Name name;
            unsigned int a;
            unsigned int b;
            unsigned int c;
        };

        Triangle();
        Triangle(const Triangle &other);
        Triangle(const QVector<Vertex> &vertex_buffer, unsigned int u, unsigned int v, unsigned int w);

        Vertex u() const;
        Vertex v() const;
        Vertex w() const;

        unsigned int u_idx() const;
        unsigned int v_idx() const;
        unsigned int w_idx() const;

        bool get_shared_edge(Triangle other, Edge &edge_a, Edge &edge_b) const;

        Triangle &operator=(const Triangle &other);

        // == and < both ignore the vertex buffer, they only compare indices.
        // They are implemented so that Triangle can be used as the key of a QMap.
        bool operator==(const Triangle &other) const;
        bool operator<(const Triangle &other) const;

    private:
        QVector<Vertex> vertex_buffer_;
        unsigned int u_;
        unsigned int v_;
        unsigned int w_;

        void rotate_indices();
        bool get_shared_edge_(const Triangle &other, Edge &edge_a, Edge &edge_b) const;
};

QDebug operator<<(QDebug d, const Triangle &triangle);

#endif
