#version 430

layout (triangles) in;
layout (triangle_strip, max_vertices = 3) out;

in vec3 teCamPosition[3];
out vec3 gCamPosition;

out vec3 gCamNormal;

out vec3 gTriDistance;

in vec3 tePatchDistance[3];
out vec3 gPatchDistance;

void main(void)
{
    // passthrough geometry shader for wireframe rendering
    // just addind TriDistance;

    vec3 normal = cross(teCamPosition[2]-teCamPosition[0],teCamPosition[1]-teCamPosition[0]);
    //normal = cross(teCamPosition[1]-teCamPosition[0],teCamPosition[2]-teCamPosition[0]);

    gTriDistance = vec3(1, 0, 0);

    gCamPosition = teCamPosition[0];
    gCamNormal = normal;
    gPatchDistance = tePatchDistance[0];
    gl_Position = gl_in[0].gl_Position;
    EmitVertex();

    gTriDistance = vec3(0, 1, 0);
    gCamPosition = teCamPosition[1];
    gCamNormal = normal;
    gPatchDistance = tePatchDistance[1];
    gl_Position = gl_in[1].gl_Position;
    EmitVertex();

    gTriDistance = vec3(0, 0, 1);
    gCamPosition = teCamPosition[2];
    gCamNormal = normal;
    gPatchDistance = tePatchDistance[2];
    gl_Position = gl_in[2].gl_Position;
    EmitVertex();

    EndPrimitive();

}
