#include "mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent)
{
    Camera *cam = new Camera();


    m_centralWidget = new MainWidget(cam);

    toolBar = new QToolBar("Animation",this);
    addToolBar(toolBar);

    loadMesh = new QAction("Load Mesh",this);
    loadMesh->setShortcut(QKeySequence("Ctrl+N"));
    connect(loadMesh, SIGNAL(triggered()), m_centralWidget, SLOT(loadNewMesh()));
    toolBar->addAction(loadMesh);

    switchRotation = new QAction("Rotation",this);
    switchRotation->setCheckable(true);
    switchRotation->setChecked(m_centralWidget->rotation);
    connect(switchRotation, SIGNAL(triggered(bool)), m_centralWidget, SLOT(setRotation(bool)));
    toolBar->addAction(switchRotation);

    switchWireframe = new QAction("Wireframe",this);
    switchWireframe->setCheckable(true);
    switchWireframe->setChecked(m_centralWidget->wireframe);
    connect(switchWireframe, SIGNAL(triggered(bool)), m_centralWidget, SLOT(setWireframe(bool)));
    toolBar->addAction(switchWireframe);


    CamHome = new QAction("Cam",this);
    CamHome->setCheckable(false);
    connect(CamHome, SIGNAL(triggered()), cam, SLOT(home()));
    toolBar->addAction(CamHome);

    debugOutput = new QAction("DebugOutput",this);
    debugOutput->setCheckable(true);
    debugOutput->setChecked(false);
    connect(debugOutput, SIGNAL(triggered(bool)), m_centralWidget, SLOT(setdebugOutput(bool)));
    toolBar->addAction(debugOutput);

    subdivSlider = new QSlider(Qt::Horizontal);
    subdivSlider->setMinimum(0);
    subdivSlider->setMaximum(5);
    subdivSlider->setSliderPosition(0);
    subdivSlider->setSingleStep(1);

    connect(subdivSlider, SIGNAL(valueChanged(int)),
            m_centralWidget, SLOT(subdivide(int)));
    toolBar->addWidget(subdivSlider);


    this->setCentralWidget(m_centralWidget);

    //  showMaximized();
}

MainWindow::~MainWindow()
{
}
