#pragma once
#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <QObject>
#include <QtOpenGL>
#include <QOpenGLWidget>
#include <QOpenGLFunctions_4_3_Core>
#include <QOpenGLShaderProgram>
#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/postprocess.h>
#include "mesh.h"
#include "camera.h"
#include "subdivision.h"


class MainWidget : public QOpenGLWidget, public QOpenGLFunctions_4_3_Core
{
    Q_OBJECT

public:
    MainWidget(Camera *cam);

    QSize minimumSizeHint() const;
    QSize sizeHint() const;

    bool rotation;
    bool wireframe;
    int subdivLevel;

public slots:
    void loadNewMesh();
    void loadNewMesh(QString path);
    void setRotation(bool started);
    void setWireframe(bool active);
    void subdivide(int level);
    void setdebugOutput(bool output);

protected:
    void initializeGL();
    void paintGL();
    void resizeGL(int width, int height);

    void mousePressEvent(QMouseEvent *event ) ;
    void mouseMoveEvent(QMouseEvent *event ) ;
    void wheelEvent(QWheelEvent *event ) ;

private:
    Camera *cam;
    QOpenGLShaderProgram* subdivisionShader;
    QOpenGLShaderProgram* regularShader;
    QMatrix4x4 m_projection;
    QTime startTime;
    QTime rotTime;
    float camDistance;
    QVector3D *lastSpeherePos;
    QPointF * lastScreenPos;
    Subdivision *subdivision;
    Mesh *mesh;

    QOpenGLShaderProgram* initShaderProgram(QString vertSource, QString tesselationControlSource, QString tesselationEvaluationSource, QString geometrySource, QString fragSource );
    QOpenGLShader* initGLShader(QString scource, QOpenGLShader::ShaderType type);
    QVector3D* trackballPoint(int x, int y);
    void rotate(QVector3D *newPos );
    void move(QPointF *newPos );
};

#endif // MAINWIDGET_H
