// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include <string>
#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/postprocess.h>

#include "Tileset.h"

#include "GameFramework/Actor.h"
#include "ProceduralMeshComponent.h"
#include "ProceduralEntity.generated.h"

UCLASS()
class  AProceduralEntity : public AActor
{
	GENERATED_BODY()
	
public:
	//UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Generation")
	FTile tile;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Generation")
	UProceduralMeshComponent* _mesh;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Generation")
	FString _filePath;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Materials")
	UMaterialInterface * MasterMaterialRef;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Materials")
	UMaterialInterface * UniformMaterialRef;

	// Sets default values for this actor's properties
	AProceduralEntity();

	void PostActorCreated();

	// Called when the game starts or when spawned
	virtual void BeginPlay() override;
	
	// Called every frame
	virtual void Tick( float DeltaSeconds ) override;

	UFUNCTION(BlueprintCallable, Category = ProceduralEntity)
	void loadModelFromBlueprint();

	UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Materials")
	TMap<int32, UMaterialInterface *> MaterialMap;

	//UPROPERTY(EditAnywhere, BlueprintReadOnly, Category = "Materials")
	//UTexture2D* diffTexture;

	void loadModel(const uint8* RawFileData, int32 lenght);

	AProceduralEntity* clone();

	void setActorDisabled(bool disabled);



private:


	int32 _selectedVertex;
	int32 _meshCurrentlyProcessed;
	bool _addModifier;
	int _lastModifiedTime;
	bool _requiresFullRecreation;
	unsigned int _numVertecies;

	TArray<TArray<FVector>> _vertices;
	TArray<TArray<int32>> _indices;
	TArray<TArray<FVector>> _normals;
	TArray<TArray<FVector2D>> _uvs;
	TArray<TArray<FProcMeshTangent>> _tangents;
	TArray<TArray<FColor>> _vertexColors;


	//USceneComponent* _rootComp;

	/* ################################################### */
	/* ################# Input methods ################### */
	/* ################################################### */
	/*
	template<int vertexNb>
	void SelectVertex();
	template<bool addModifier>
	void ChangeAddModifier();
	void ChangeVertex(FVector dv);*/

	void processMesh(aiMesh* mesh, const aiScene* scene, FMatrix modelTransform);
	void processNode(aiNode* node, const aiScene* scene, FMatrix modelTransform);
	
	UMaterialInterface  *GetMaterialForIndex(unsigned int index, const aiScene* scene);
};