// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Pawn.h"
#include "RabbitMQConnection.h"
#include "UDPSender.h"
#include "VRPawnCode.generated.h"

UCLASS()
class MASTERTESTPROJECT_API AVRPawnCode : public APawn
{
	GENERATED_BODY()

public:
	// Sets default values for this pawn's properties
	AVRPawnCode();
	float counter = 0;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Points")
	UMaterialInstanceDynamic *PointCloudMaterials;


protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

public:	
	// Called every frame
	virtual void Tick(float DeltaTime) override;

	// Called to bind functionality to input
	virtual void SetupPlayerInputComponent(class UInputComponent* PlayerInputComponent) override;

	UFUNCTION(BlueprintCallable, Category = "RabbitMQ")
	void PublishMessage(FVector start, FVector end, AUDPSender *socket);


	UFUNCTION(BlueprintCallable, Category = "pointCloud")
	void setPoincloudPosition(FVector position, float angle);

	
	
};
