// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "MyGameInstance.h"
#include "PointCloudActor.h"
#include "VRPawnCode.h"



// Sets default values
AVRPawnCode::AVRPawnCode()
{
 	// Set this pawn to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;



}

// Called when the game starts or when spawned
void AVRPawnCode::BeginPlay()
{
	Super::BeginPlay();
	
	UMyGameInstance *gameinstance = Cast<UMyGameInstance>(GetGameInstance());
	
	if (gameinstance != nullptr && !gameinstance->connection) {
		gameinstance->connection = NewObject<URabbitMQConnection>();
	}
	
	char const *messagebody = "{\"timestamp\":15.600000381469727,\"start\":{\"x\":0.0,\"y\":0.0,\"z\":0.0},\"end\":{\"x\":1.0,\"y\":5.0,\"z\":16.0}}";

}

// Called every frame
void AVRPawnCode::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);

}

// Called to bind functionality to input
void AVRPawnCode::SetupPlayerInputComponent(UInputComponent* PlayerInputComponent)
{
	Super::SetupPlayerInputComponent(PlayerInputComponent);

}

void AVRPawnCode::PublishMessage(FVector start, FVector end, AUDPSender *socket)
{
	UMyGameInstance *gameinstance = Cast<UMyGameInstance>(GetGameInstance());
	//FPlatformTime::Seconds();
	FString Message = FString::Printf(TEXT("{\"timestamp\":%f,\"start\":{\"x\":%f,\"y\":%f,\"z\":%f},\"end\":{\"x\":%f,\"y\":%f,\"z\":%f}}"), counter++,  start.Y / 100.0f, start.Z / 100.0f, start.X/100.0f, end.Y / 100.0f, end.Z / 100.0f, end.X / 100.0f);
	socket->SendString(Message);
	//UE_LOG(UDP, Warning, TEXT("Published Message %s"), *Message);
	//gameinstance->connection->publishMessage(TCHAR_TO_UTF8(*Message));

}

void AVRPawnCode::setPoincloudPosition(FVector position, float angle)
{
	if (!PointCloudMaterials) {
		TArray<AActor*> FoundActors;
		UGameplayStatics::GetAllActorsOfClass(GetWorld(), APointCloudActor::StaticClass(), FoundActors);
		APointCloudActor* actor;
		for (int i = 0; i < FoundActors.Num(); i++) {
			actor = (APointCloudActor*) FoundActors[i];
			PointCloudMaterials = actor->Material;
		}

	}
	if (PointCloudMaterials) {
		FLinearColor(position.X, position.Y, position.Z, angle);
		PointCloudMaterials->SetVectorParameterValue(FName("TrackerPos"), FLinearColor(position.X, position.Y, position.Z, angle));
		PointCloudMaterials->SetScalarParameterValue(FName("TrackerZRotation"), angle);
		//UE_LOG(TILES, Warning, TEXT("Setting %s Pos %s Angle %f"), *position.ToString(), *PointCloudMaterials->GetName(), angle);
	}
}

