// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "Networking.h"
#include "UDPSender.generated.h"

UCLASS()
class MASTERTESTPROJECT_API AUDPSender : public AActor
{
	GENERATED_BODY()

	bool IsUDP;


	
public:	
	// Sets default values for this actor's properties
	AUDPSender();

	TSharedPtr<FInternetAddr>	RemoteAddr;
	FSocket* SenderSocket;

	UFUNCTION(BlueprintCallable, Category = UDPSender)
	bool StartUDPSender(
		const FString& YourChosenSocketName,
		const FString& TheIP,
		const int32 ThePort
	);

	UFUNCTION(BlueprintCallable, Category = UDPSender)
	bool SendString(FString ToSend);

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

	/** Called whenever this actor is being removed from a level */
	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;


	
	
};
