// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "UDPSender.h"


// Sets default values
AUDPSender::AUDPSender()
{
 	// Set this actor to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = false;
	SenderSocket = nullptr;
	
}


bool AUDPSender::SendString(FString ToSend)
{
	if (!SenderSocket)
	{
		UE_LOG(UDP, Error, TEXT("No UDP sender socket"));
		return false;
	}
	//~~~~~~~~~~~~~~~~

	int32 BytesSent = 0;
	
	//FAnyCustomData NewData;
	//NewData.Scale = FMath::FRandRange(0, 1000);
	//NewData.Count = FMath::RandRange(0, 100);
	//NewData.Color = FLinearColor(FMath::FRandRange(0, 1), FMath::FRandRange(0, 1), FMath::FRandRange(0, 1), 1);

	FArrayWriter Writer;

	//Writer << ToSend; // NewData; //Serializing our custom data, thank you UE4!

	FTCHARToUTF8 EchoStrUtf8(*ToSend);

	int32 DestLen = EchoStrUtf8.Length();

	//int SentLen = libwebsocket_write(Wsi, (unsigned char*)(TCHAR_TO_UTF8(*EchoStr)), DestLen, LWS_WRITE_TEXT);
	//std::string messageSTDString = TCHAR_TO_UTF8(*Message);

	SenderSocket->SendTo((unsigned char*)(TCHAR_TO_UTF8(*ToSend)), DestLen, BytesSent, *RemoteAddr);

	if (BytesSent <= 0)
	{
		UE_LOG(UDP, Error, TEXT("Socket is valid but the receiver received 0 bytes, make sure it is listening properly! DestLen = %d "), DestLen);
		return false;
	}

	//UE_LOG(LogTemp, Log, TEXT("UDP~ Send Succcess! Bytes Sent = %d"), BytesSent);

	return true;
}

bool AUDPSender::StartUDPSender(const FString & YourChosenSocketName, const FString & TheIP, const int32 ThePort)
{
	//Create Remote Address.
	RemoteAddr = ISocketSubsystem::Get(PLATFORM_SOCKETSUBSYSTEM)->CreateInternetAddr();

	bool bIsValid;
	RemoteAddr->SetIp(*TheIP, bIsValid);
	RemoteAddr->SetPort(ThePort);

	if (!bIsValid)
	{
		UE_LOG(UDP, Error, TEXT("Rama UDP Sender>> IP address  %s was not valid!"), *TheIP);
		return false;
	}

	SenderSocket = FUdpSocketBuilder(*YourChosenSocketName)
		.AsReusable()
		.WithBroadcast()
		;


	//check(SenderSocket->GetSocketType() == SOCKTYPE_Datagram);

	//Set Send Buffer Size
	int32 SendSize = 2 * 1024 * 1024;
	SenderSocket->SetSendBufferSize(SendSize, SendSize);
	SenderSocket->SetReceiveBufferSize(SendSize, SendSize);

	UE_LOG(UDP, Log, TEXT("\n\n\n~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"));
	UE_LOG(UDP, Log, TEXT("Rama ****UDP**** Sender Initialized Successfully!!!"));
	UE_LOG(UDP, Log, TEXT("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n\n"));

	return true;
}

// Called when the game starts or when spawned
void AUDPSender::BeginPlay()
{
	Super::BeginPlay();
	
}

void AUDPSender::EndPlay(const EEndPlayReason::Type EndPlayReason)
{
	Super::EndPlay(EndPlayReason);
	//~~~~~~~~~~~~~~~~

	if (SenderSocket)
	{
		SenderSocket->Close();
		ISocketSubsystem::Get(PLATFORM_SOCKETSUBSYSTEM)->DestroySocket(SenderSocket);
	}
}

