// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "TileDownloader.h"


void UTileDownloader::GetTileContent(ATilesetActor *Actor, FTileContent *Content, FString &baseUrl, FTile *tile)
{

	parent = Content;
	parentTile = tile;
	actor = Actor;
	DownloadFile(ResolveRealativeURL(baseUrl, *Content->url));
}



void UTileDownloader::OnResponseReceived(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful)
{
	//UE_LOG(TILES, Log, TEXT("Tiledownloader Response: %s Success: %s"), *Request->GetURL());

	//FIXME download with error in http
	if (Response.IsValid()) {
		if (Request->GetURL().EndsWith(TEXT(".json"))) {
			UE_LOG(TILES, Log, TEXT("Downloded Tilset: %s Scucess: %s"), *Request->GetURL(), bWasSuccessful ? TEXT("True") : TEXT("False"));
			parent->tileset = actor->parseTileset(Response->GetContentAsString(), Request->GetURL());
			if(parent->tileset)
				parent->tileset->parent = parentTile;
		}
		else {
			FString url = Request->GetURL();
			UE_LOG(TILES, Warning, TEXT("Downloded Tile: %s Scucess: %s "), *Request->GetURL(), bWasSuccessful ? TEXT("True") : TEXT("False"));
			actor->parse3DTile(Response->GetContent(), parentTile);	
		}
	}
	else {
		UE_LOG(TILES, Error, TEXT("Downlaod Finished: %s Scucess: %s not Valid"), *Request->GetURL(), bWasSuccessful ? TEXT("True") : TEXT("False"));
	}
}