// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "RabbitMQConnection.h"

URabbitMQConnection::URabbitMQConnection(const FObjectInitializer& ObjectInitializer) : Super(ObjectInitializer) {
	char const *hostname = "10.1.7.49";
	int port = 5672;


	conn = amqp_new_connection();
	socket = amqp_tcp_socket_new(conn);
	if (!socket) {
		UE_LOG(TILES, Error, TEXT("No RabbitMQ Socket"));
	}

	int status = amqp_socket_open(socket, hostname, port);
	if (status) {
		UE_LOG(TILES, Error, TEXT("Cann not Open Socket"));
	}

	amqp_rpc_reply_t returncode = amqp_login(conn, "/", 0, 131072, 0, AMQP_SASL_METHOD_PLAIN, "guest", "guest");
	if (AMQP_RESPONSE_NORMAL != returncode.reply_type) {
		UE_LOG(TILES, Error, TEXT("Unable to Login"));
	}


	amqp_channel_open(conn, 1);
	returncode = amqp_get_rpc_reply(conn);
	if (AMQP_RESPONSE_NORMAL != returncode.reply_type) {
		UE_LOG(TILES, Error, TEXT("Opening channel error"));
	}
	success = true;
}

URabbitMQConnection::~URabbitMQConnection()
{
	if (!success) {
		return;
	}
	amqp_rpc_reply_t returncode = amqp_channel_close(conn, 1, AMQP_REPLY_SUCCESS);
	if (AMQP_RESPONSE_NORMAL != returncode.reply_type) {
		UE_LOG(TILES, Error, TEXT("Closing channel error"));
	}

	returncode = amqp_connection_close(conn, AMQP_REPLY_SUCCESS);
	if (AMQP_RESPONSE_NORMAL != returncode.reply_type) {
		UE_LOG(TILES, Error, TEXT("Closing connection error"));
	}
	int errorcode = amqp_destroy_connection(conn);
	if (errorcode != 0) {
		UE_LOG(TILES, Error, TEXT("Ending AMQP error"));
	}
}

bool URabbitMQConnection::publishMessage(char const * Message)
{
	if (!success){
		UE_LOG(TILES, Warning, TEXT("Cant send Messsage, no Connection"));
		return false;
	}
		

	char const *exchange = "";
	char const *routingkey = "to_hololense";

//	char const *messagebody = "{\"timestamp\":15.600000381469727,\"start\":{\"x\":0.0,\"y\":0.0,\"z\":0.0},\"end\":{\"x\":1.0,\"y\":5.0,\"z\":16.0}}";
	amqp_basic_properties_t props;
	props._flags = AMQP_BASIC_CONTENT_TYPE_FLAG | AMQP_BASIC_DELIVERY_MODE_FLAG;
	props.content_type = amqp_cstring_bytes("text/plain");
	props.delivery_mode = 2; /* persistent delivery mode */
	int errorcode = amqp_basic_publish(conn,
		1,
		amqp_cstring_bytes(exchange),
		amqp_cstring_bytes(routingkey),
		0,
		0,
		&props,
		amqp_cstring_bytes(Message));

	if (errorcode != 0) {
		UE_LOG(TILES, Error, TEXT("Publishing error"));
	}
	//UE_LOG(TILES, Warning, TEXT("Published Message %s"), Message);
	return true;
}
