// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "GameFramework/Actor.h"
#include "PointCloudActor.generated.h"

UCLASS()
class MASTERTESTPROJECT_API APointCloudActor : public AActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	APointCloudActor(const FObjectInitializer& ObjectInitializer);
	void setPoints(UTexture2D* Points, FVector pos, FVector scale, float TextureOffset);
	void setColors(UTexture2D* Colors);

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Material")
	UMaterialInstanceDynamic* Material;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Points")
	UStaticMesh* StaticMesh;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Points")
	UStaticMeshComponent* StaticMeshComponent;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Points")
	UTexture2D* Points;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Points")
	UTexture2D* Colors;

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

public:	
	FVector Offset;
	// Called every frame
	virtual void Tick(float DeltaTime) override;

	
	
};
