// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "VRPawnCode.h"
#include "PointCloudActor.h"


// Sets default values
APointCloudActor::APointCloudActor(const FObjectInitializer& ObjectInitializer)
{
 	// Set this actor to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;
	
	//Create Static Mesh
	static ConstructorHelpers::FObjectFinder<UStaticMesh> StaticMeshOb_AW2(TEXT("StaticMesh'/Game/PointClouds/quadchain-2-20.quadchain-2-20'"));
	//static ConstructorHelpers::FObjectFinder<UStaticMesh> StaticMeshOb_AW2(TEXT("StaticMesh'/Game/PointClouds/quadchain4096.quadchain4096'"));
	//static ConstructorHelpers::FObjectFinder<UStaticMesh> StaticMeshOb_AW2(TEXT("StaticMesh'/Game/PointClouds/quadchain32.quadchain32'"));
	//static ConstructorHelpers::FObjectFinder<UStaticMesh> StaticMeshOb_AW2(TEXT("StaticMesh'/Game/PointClouds/square.square'"));
	
	StaticMesh = StaticMeshOb_AW2.Object;
	StaticMeshComponent = ObjectInitializer.CreateDefaultSubobject < UStaticMeshComponent >(this, TEXT("Poins"));
	StaticMeshComponent->SetStaticMesh(StaticMesh);


	//Create Material
	static ConstructorHelpers::FObjectFinder<UMaterial> MaterialPrototype(TEXT("Material'/Game/PointClouds/StaticPointCloudMat.StaticPointCloudMat'"));

	if (MaterialPrototype.Object != NULL)
	{
		UMaterial* TheMaterial = (UMaterial*)MaterialPrototype.Object;
		Material = UMaterialInstanceDynamic::Create(TheMaterial, nullptr);
		StaticMeshComponent->SetMaterial(0, Material);
	}
	

}

void APointCloudActor::setPoints(UTexture2D* PointCloud, FVector pos, FVector scale, float TextureOffset){
	//if (pos.Y < 0) pos.Y = 0;
	UE_LOG(TILES, Log, TEXT("PointclodActor pos: %s size: %s"), *pos.ToString(), *scale.ToString());
	Material->SetTextureParameterValue(FName("PointCloud"), PointCloud);
	Material->SetScalarParameterValue(FName("TextureSize"), PointCloud->GetSizeX());
	Offset = pos;
	Material->SetVectorParameterValue(FName("CloudCenter"), pos);
	Material->SetVectorParameterValue(FName("BoundigBox"), scale);
	Material->SetScalarParameterValue(FName("TextureOffset"), TextureOffset);
	Material->SetScalarParameterValue(FName("TrackerZRotation"), 0);
	Points = PointCloud;
	StaticMeshComponent->SetMaterial(0, Material);
	
}

void APointCloudActor::setColors(UTexture2D* ColorsTexture) {
	Material->SetTextureParameterValue(FName("Colors"), ColorsTexture);
	this->Colors = ColorsTexture;
	StaticMeshComponent->SetMaterial(0, Material);

}

// Called when the game starts or when spawned
void APointCloudActor::BeginPlay()
{
	Super::BeginPlay();
	//StaticMeshComponent->AttachToComponent(RootComponent, FAttachmentTransformRules::KeepRelativeTransform);
	
}

// Called every frame
void APointCloudActor::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);

}

