// Fill out your copyright notice in the Description page of Project Settings.

using UnrealBuildTool;
using System;
using System.IO;

public class MasterTestProject : ModuleRules
{
    private string ModulePath
    {
        get { return ModuleDirectory; }
    }

    private string ThirdPartyPath
    {
        get { return Path.GetFullPath(Path.Combine(ModulePath, "../../")); }
    }


    public MasterTestProject(ReadOnlyTargetRules Target) : base (Target)
    {   

        PublicDependencyModuleNames.AddRange(new string[] { "Core", "CoreUObject", "Engine", "InputCore", "ImageWrapper",
                                                    "RawMesh",  "JsonUtilities", "ProceduralMeshComponent", "RHI", "RenderCore",
                                                    "HTTP", "Json","Sockets", "Networking" });

        PrivateDependencyModuleNames.AddRange(new string[] {  });

        LoadAssimp(Target);
        LoadAMQP(Target);

        // Uncomment if you are using Slate UI
        // PrivateDependencyModuleNames.AddRange(new string[] { "Slate", "SlateCore" });

        // Uncomment if you are using online features
        // PrivateDependencyModuleNames.Add("OnlineSubsystem");

        // To include OnlineSubsystemSteam, add it to the plugins section in your uproject file with the Enabled attribute set to true
    }

    public bool LoadAssimp(ReadOnlyTargetRules Target)
    {
        bool isLibrarySupported = false;

        if ((Target.Platform == UnrealTargetPlatform.Win64) || (Target.Platform == UnrealTargetPlatform.Win32))
        {
            isLibrarySupported = true;

            // string PlatformString = (Target.Platform == UnrealTargetPlatform.Win64) ? "x64" : "x86";
            string LibrariesPath = Path.Combine(ThirdPartyPath, "assimp", "bin64", "code", "Debug");
           // string dllPath = Path.Combine(ThirdPartyPath, "assimp", "bin", "Debug");

            //test your path with:
            //using System; Console.WriteLine("");
            Console.WriteLine(".. Target {0}", Target.Platform);
            Console.WriteLine("... LibrariesPath -> " + LibrariesPath);
           // Console.WriteLine("... DLLPath -> " + dllPath);

            PublicLibraryPaths.Add(LibrariesPath);
            //PublicLibraryPaths.Add(dllPath);
            PublicAdditionalLibraries.Add(Path.Combine(LibrariesPath, "assimp-vc140-mt.lib"));// + PlatformString + ".lib"));
            //sPublicAdditionalLibraries.Add(Path.Combine(LibrariesPath, "zlibstaticd.lib"));
           // PublicDelayLoadDLLs.Add(Path.Combine(dllPath, "assimp-vc140-mt.dll"));
        }

        if (isLibrarySupported)
        {
            // Include path
            PublicIncludePaths.Add(Path.Combine(ThirdPartyPath, "assimp", "include"));

        }

        Definitions.Add(string.Format("WITH_ASSIMP_BINDING={0}", isLibrarySupported ? 1 : 0));
        

        return isLibrarySupported;
    }

    public bool LoadAMQP(ReadOnlyTargetRules Target)
    {
        bool isLibrarySupported = false;

        if ((Target.Platform == UnrealTargetPlatform.Win64) || (Target.Platform == UnrealTargetPlatform.Win32))
        {
            isLibrarySupported = true;

            // string PlatformString = (Target.Platform == UnrealTargetPlatform.Win64) ? "x64" : "x86";
            string LibrariesPath = Path.Combine("H:\\Repositories\\rabbitmq-c\\vs17\\librabbitmq\\Debug");
            // string dllPath = Path.Combine(ThirdPartyPath, "assimp", "bin", "Debug");

            //test your path with:
            //using System; Console.WriteLine("");
            Console.WriteLine(".. Target {0}", Target.Platform);
            Console.WriteLine("... LibrariesPath -> " + LibrariesPath);
            // Console.WriteLine("... DLLPath -> " + dllPath);

            PublicLibraryPaths.Add(LibrariesPath);
            //PublicLibraryPaths.Add(dllPath);
            PublicAdditionalLibraries.Add(Path.Combine(LibrariesPath, "rabbitmq.4.lib"));// + PlatformString + ".lib"));
            PublicAdditionalLibraries.Add(Path.Combine(LibrariesPath, "librabbitmq.4.lib"));// + PlatformString + ".lib"));

            //sPublicAdditionalLibraries.Add(Path.Combine(LibrariesPath, "zlibstaticd.lib"));
            // PublicDelayLoadDLLs.Add(Path.Combine(dllPath, "assimp-vc140-mt.dll"));
        }

        if (isLibrarySupported)
        {
            // Include path
            PublicIncludePaths.Add(Path.Combine("H:\\Repositories\\rabbitmq-c\\librabbitmq"));

        }

        Definitions.Add(string.Format("WITH_RABBITMQ_BINDING={0}", isLibrarySupported ? 1 : 0));


        return isLibrarySupported;
    }

    public bool LoadAssimp2(TargetInfo Target)
    {
        bool isLibrarySupported = false;

        if ((Target.Platform == UnrealTargetPlatform.Win64) || (Target.Platform == UnrealTargetPlatform.Win32))
        {
            isLibrarySupported = true;

            // string PlatformString = (Target.Platform == UnrealTargetPlatform.Win64) ? "x64" : "x86";
            string LibrariesPath = Path.Combine(ThirdPartyPath, "assimp-3.1.1-win-binaries", "lib64");
            string dllPath = Path.Combine(ThirdPartyPath, "assimp-3.1.1-win-binaries", "bin64");

            //test your path with:
            //using System; Console.WriteLine("");
            Console.WriteLine(".. Target {0}", Target.Platform);
            Console.WriteLine("... LibrariesPath -> " + LibrariesPath);
            Console.WriteLine("... DLLPath -> " + dllPath);

            PublicLibraryPaths.Add(LibrariesPath);
            PublicLibraryPaths.Add(dllPath);
            PublicAdditionalLibraries.Add(Path.Combine(LibrariesPath, "assimp.lib"));// + PlatformString + ".lib"));
            PublicDelayLoadDLLs.Add(Path.Combine(dllPath, "assimp.dll"));
        }

        if (isLibrarySupported)
        {
            // Include path
            PublicIncludePaths.Add(Path.Combine(ThirdPartyPath, "assimp-3.1.1-win-binaries", "include"));

        }

        Definitions.Add(string.Format("WITH_ASSIMP_BINDING={0}", isLibrarySupported ? 1 : 0));


        return isLibrarySupported;
    }
}
