// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "HttpDownloader.h"
#include "ImageUtils.h"
#include "ImageWrapper.h"	//requires "ImageWrapper" in public dependencies in build CS
#include "ImageDownloader.generated.h"

/**
 * 
 */
UCLASS()
class MASTERTESTPROJECT_API UImageDownloader : public UHttpDownloader
{
	GENERATED_BODY()
	
private:
	UMaterialInstanceDynamic *_Material;
	FName _TextureName;

public:

	void GetTextureForMaterial(UMaterialInstanceDynamic* Material, FName TextureName, FString &baseUrl, FString &Url);

	virtual void OnResponseReceived(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful);

	static UTexture2D* LoadTexture2D(const uint8* RawFileData, int32 lenght, EImageFormat::Type Format, bool& IsValid, int32& Width, int32& Height);
	static EImageFormat::Type GetImageTypeByExtension(const FString& extension);
	
};
