// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "ImageDownloader.h"

void UImageDownloader::GetTextureForMaterial(UMaterialInstanceDynamic *Material, FName TextureName, FString & baseUrl, FString & Url)
{
	_Material = Material;
	_TextureName = TextureName;

	DownloadFile(ResolveRealativeURL(baseUrl, Url));

}

void UImageDownloader::OnResponseReceived(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful)
{
	EImageFormat::Type format = GetImageTypeByExtension(FPaths::GetExtension(Request->GetURL()));

	bool isValid;
	int32 width, height;
	UTexture2D* diffTexture = UImageDownloader::LoadTexture2D(Response->GetContent().GetData(), Response->GetContent().Num(), format, isValid, width, height);
	if (isValid)
		_Material->SetTextureParameterValue(_TextureName, diffTexture);

}


EImageFormat::Type UImageDownloader::GetImageTypeByExtension(const FString& extension) {
	EImageFormat::Type format = EImageFormat::Invalid;
	if (extension.EndsWith(TEXT("jpg"), ESearchCase::IgnoreCase)) {
		format = EImageFormat::JPEG;
	}
	else if (extension.EndsWith(TEXT("png"), ESearchCase::IgnoreCase)) {
		format = EImageFormat::PNG;
	}
	else if (extension.EndsWith(TEXT("bmp"), ESearchCase::IgnoreCase)) {
		format = EImageFormat::BMP;
	}
	else if (extension.EndsWith(TEXT("ico"), ESearchCase::IgnoreCase)) {
		format = EImageFormat::ICO;
	}
	else if (extension.EndsWith(TEXT("exr"), ESearchCase::IgnoreCase)) {
		format = EImageFormat::EXR;
	}
	else if (extension.EndsWith(TEXT("icns"), ESearchCase::IgnoreCase)) {
		format = EImageFormat::ICNS;
	}
	return format;
}

UTexture2D* UImageDownloader::LoadTexture2D(const uint8* RawFileData, int32 lenght, EImageFormat::Type Format, bool& IsValid, int32& Width, int32& Height) {
	IsValid = false;
	UTexture2D* LoadedT2D = NULL;

	IImageWrapperModule& ImageWrapperModule = FModuleManager::LoadModuleChecked<IImageWrapperModule>(FName("ImageWrapper"));
	IImageWrapperPtr ImageWrapper = ImageWrapperModule.CreateImageWrapper(Format);



	//Create T2D!
	if (ImageWrapper.IsValid() && ImageWrapper->SetCompressed(RawFileData, lenght))
	{
		const TArray<uint8>* UncompressedBGRA = NULL;
		if (ImageWrapper->GetRaw(ERGBFormat::BGRA, 8, UncompressedBGRA))
		{
			LoadedT2D = UTexture2D::CreateTransient(ImageWrapper->GetWidth(), ImageWrapper->GetHeight(), PF_B8G8R8A8);

			//Valid?
			if (!LoadedT2D) return NULL;
			//~~~~~~~~~~~~~~

			//Out!
			Width = ImageWrapper->GetWidth();
			Height = ImageWrapper->GetHeight();

			//Copy!
			void* TextureData = LoadedT2D->PlatformData->Mips[0].BulkData.Lock(LOCK_READ_WRITE);
			FMemory::Memcpy(TextureData, UncompressedBGRA->GetData(), UncompressedBGRA->Num());
			LoadedT2D->PlatformData->Mips[0].BulkData.Unlock();

			//Update!
			LoadedT2D->UpdateResource();
		}
	}

	// Success!
	IsValid = true;
	return LoadedT2D;
}