// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "UObject/NoExportTypes.h"
#include "Runtime/Online/HTTP/Public/Http.h"
#include "HttpDownloader.generated.h"

/**
 * 
 */
UCLASS()
class MASTERTESTPROJECT_API UHttpDownloader : public UObject
{
	GENERATED_BODY()

public:
	UFUNCTION()
	FString ResolveRealativeURL(const FString &BaseUrl, const FString &RelativeUrl);


	UFUNCTION()
	void DownloadFile(const FString &URL);

	/*Assign this function to call when the GET request processes sucessfully*/
	virtual void OnResponseReceived(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful);

	
	
};
