// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "HttpDownloader.h"


void UHttpDownloader::DownloadFile(const FString &URL)
{
	TSharedRef< IHttpRequest > HttpRequest = FHttpModule::Get().CreateRequest();
	HttpRequest->SetVerb("GET");
	HttpRequest->SetURL(URL);
	//HttpRequest->SetURL(TEXT("http://localhost/tileset.json"));
	
	
	HttpRequest->OnProcessRequestComplete().BindUObject(this, &UHttpDownloader::OnResponseReceived);

	// Execute the request 

	bool sucess = HttpRequest->ProcessRequest();

	UE_LOG(TILES, Log, TEXT("Downlaoding : %s successfull Start %d "), *HttpRequest->GetURL(), (int)sucess);

}

void UHttpDownloader::OnResponseReceived(FHttpRequestPtr Request, FHttpResponsePtr Response, bool bWasSuccessful)
{
	if (Response.IsValid()) {
		UE_LOG(TILES, Warning, TEXT("Default Downlaod Finished: %s Scucess: %s \"%s\""), *Request->GetURL(), bWasSuccessful ? TEXT("True") : TEXT("False"), *Response->GetContentAsString());
	}
	else {
		UE_LOG(TILES, Warning, TEXT("Downlaod Finished: %s Scucess: %s not Valid"), *Request->GetURL(), bWasSuccessful ? TEXT("True") : TEXT("False"));
	}
}

FString UHttpDownloader::ResolveRealativeURL(const FString &BaseUrl, const FString &RelativeUrl) {
	if (RelativeUrl.StartsWith("file") || RelativeUrl.StartsWith("http")) {
		//absolute Url
		UE_LOG(TILES, Log, TEXT("Absolute URL %s "), *RelativeUrl);
		return RelativeUrl;
	}

	FString BaseUrlnormalized, RelativeUrlnormalized;
	BaseUrlnormalized = BaseUrl.Replace(TEXT("\\"), TEXT("/"));
	RelativeUrlnormalized = RelativeUrl.Replace(TEXT("\\"), TEXT("/"));

	FString basePath, right;

	if (!BaseUrlnormalized.Split(TEXT("/"), &basePath, &right, ESearchCase::IgnoreCase, ESearchDir::FromEnd)) {
		basePath = BaseUrlnormalized;
	}
	//UE_LOG(GLTF, Warning, TEXT("Diffuse Texture:\"%s\" \"%s\""), *dirPath, *fileName);

	FString url = basePath + "/" + RelativeUrlnormalized;

	//UE_LOG(TILES, Log, TEXT("Relative URl: Base:%s, Relative %s, -> %s "), *BaseUrlnormalized, *RelativeUrlnormalized, *url);

	return url;

}
