// Fill out your copyright notice in the Description page of Project Settings.

#include "MasterTestProject.h"
#include "DynamicTextureUtilities.h"




// NOTE hard-coded to 64 * 64 texture sizes! I just copied this from some of my own code and modified it for you a little. You'll want to change a bunch of stuff in here for your own purposes.

void UDynamicTextureUtilities::UpdateTextureRegion(UTexture2D* Texture, int32 MipIndex, FUpdateTextureRegion2D Region, uint32 SrcPitch, uint32 SrcBpp, uint8* SrcData, bool bFreeData)
{
	if (Texture->Resource)
	{
		struct FUpdateTextureRegionsData
		{
			FTexture2DResource* Texture2DResource;
			int32 MipIndex;
			FUpdateTextureRegion2D Region;
			uint32 SrcPitch;
			uint32 SrcBpp;
			uint8* SrcData;
		};

		FUpdateTextureRegionsData* RegionData = new FUpdateTextureRegionsData;

		RegionData->Texture2DResource = (FTexture2DResource*)Texture->Resource;
		RegionData->MipIndex = MipIndex;
		RegionData->Region = Region;
		RegionData->SrcPitch = SrcPitch;
		RegionData->SrcBpp = SrcBpp;
		RegionData->SrcData = SrcData;

		{

			ENQUEUE_UNIQUE_RENDER_COMMAND_TWOPARAMETER(
				UpdateTextureRegionsData,
				FUpdateTextureRegionsData*, RegionData, RegionData,
				bool, bFreeData, bFreeData,
				{
					int32 CurrentFirstMip = RegionData->Texture2DResource->GetCurrentFirstMip();
					if (RegionData->MipIndex >= CurrentFirstMip)
					{
						RHIUpdateTexture2D(
							RegionData->Texture2DResource->GetTexture2DRHI(),
							RegionData->MipIndex - CurrentFirstMip,
							RegionData->Region,
							RegionData->SrcPitch,
							RegionData->SrcData
							+ RegionData->Region.SrcY * RegionData->SrcPitch
							+ RegionData->Region.SrcX * RegionData->SrcBpp
						);
					}
					// TODO is this leaking if we never set this to true??
					if (bFreeData)
					{
						FMemory::Free(RegionData->SrcData);
					}
				delete RegionData;
				});

		}
	}
}

void UDynamicTextureUtilities::UpdateDynamicVectorTexture(const TArray<FLinearColor>& Source, UTexture2D* Texture, bool bFreeData)
{
	// Only handles 32-bit float textures
	if (!Texture || Texture->GetPixelFormat() != PF_A32B32G32R32F) return;
	// Shouldn't do anything if there's no data
	if (Source.Num() < 1) return;

	UpdateTextureRegion(Texture, 0, FUpdateTextureRegion2D(0, 0, 0, 0, Texture->GetSizeX(), Texture->GetSizeY()), Texture->GetSizeX() * sizeof(FLinearColor), sizeof(FLinearColor), (uint8*)Source.GetData(), bFreeData);
}

UTexture2D* UDynamicTextureUtilities::CreateTransientDynamicTexture(int32 Width, int32 Height, EPixelFormat PixelFormat)
{
	auto* Texture = UTexture2D::CreateTransient(Width, Height, PixelFormat);
	if (Texture)
	{
		Texture->CompressionSettings = TextureCompressionSettings::TC_HDR; // TC_VectorDisplacementmap;
		Texture->SRGB = 0;
		Texture->UpdateResource();
	}
	return Texture;
}


//not used
UTexture2D* UDynamicTextureUtilities::CreateDynamicTextureWithData(int length, uint8* data)
{
	
	int32 size = FMath::FloorToInt(FMath::Sqrt(length))+1;

	UE_LOG(TILES, Error, TEXT("Texturein %d, size  %d"), length, size);

	auto* Texture = UTexture2D::CreateTransient(size, size, PF_FloatRGB);
	if (Texture)
	{
		Texture->CompressionSettings = TextureCompressionSettings::TC_VectorDisplacementmap;
		Texture->SRGB = 0;
		Texture->UpdateResource();
	}



	UpdateTextureRegion(Texture, 0,
		FUpdateTextureRegion2D(0, 0, 0, 0, size, size),
		size * 3 * sizeof(float), 3 * sizeof(float), data, false);


	return Texture;

}

/*
void UDynamicTextureUtilities::SetDynamicTextureAndIndex(class UStaticMeshComponent* Component, class UTexture2D* Texture, int32 Index, FName IndexParameterName, FName TextureParameterName)
{
	if (!Component || !Texture) return;
	for (int32 i = 0; i < Component->GetNumMaterials(); i++)
	{
		auto* DynamicMaterial = FMyProjInstanceProcedures::TryGetDynamicMaterial(Component, i);
		if (!DynamicMaterial) continue;
		FLinearColor CalculatedIndex(FMath::Fmod((float)Index, 64.0f) + 0.5f, FMath::FloorToFloat((float)Index / 64.0f) + 0.5f, 0.0f, 0.0f);
		CalculatedIndex /= 64.0f;
		DynamicMaterial->SetVectorParameterValue(IndexParameterName, CalculatedIndex);
		DynamicMaterial->SetTextureParameterValue(TextureParameterName, Texture);
	}
}
*/