#include "scenevolume.h"

SceneVolume::SceneVolume(int width,int height, int depth, double dx, double dy, double dz)
{
    this->width = width;
    this->height = height;
    this->depth = depth;

    this->dx = dx;
    this->dy = dy;
    this->dz = dz;

    lx = width*dx;
    ly = height*dy;
    lz = depth*dz;

    qDebug()<<lx<<ly<<lz;

    double max = qMax(lx,qMax(ly,lz));



    lx = lx/max;
    ly = ly/max;
    lz = lz/max;

    qDebug()<<max<<lx<<ly<<lz;

    this->setName("Volume");

}


void SceneVolume::draw(QGLShaderProgram *shader){
    glPushMatrix();
    applyTransformation();

    shader->setUniformValue("volume", true);

    QMatrix4x4 mat = QMatrix4x4();
    mat.rotate(getGlobalRotation().conjugate());
    glMultMatrixf(mat.data());

 //   shader->setUniformValue("volumeRot",mat);

    glDisable(GL_DEPTH_TEST);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable( GL_BLEND );

    float x = lx/2;
    float y = ly/2;
    float z = lz/2;

    glBegin(GL_QUADS);
    glNormal3f(0,1,0);
    glTexCoord3i(1,1,0);
    glVertex3f(  x,  y, -z);
    glTexCoord3i(0,1,0);
    glVertex3f( -x,  y, -z);
    glTexCoord3i(0,1,1);
    glVertex3f( -x,  y,  z);
    glTexCoord3i(1,1,1);
    glVertex3f(  x,  y,  z);
    glEnd();

    glBegin(GL_QUADS);
    glNormal3f(0,-1,0);
    glTexCoord3i(1,0,1);
    glVertex3f(  x,  -y,  z);
    glTexCoord3i(0,0,1);
    glVertex3f( -x,  -y,  z);
    glTexCoord3i(0,0,0);
    glVertex3f( -x,  -y, -z);
    glTexCoord3i(1,0,0);
    glVertex3f(  x,  -y, -z);
    glEnd();

    glBegin(GL_QUADS);
    glNormal3f(0,0,1);
    glTexCoord3i(1,1,1);
    glVertex3f(  x,  y,  z);
    glTexCoord3i(0,1,1);
    glVertex3f( -x,  y,  z);
    glTexCoord3i(0,0,1);
    glVertex3f( -x,  -y,  z);
    glTexCoord3i(1,0,1);
    glVertex3f(  x,  -y,  z);
    glEnd();

    glBegin(GL_QUADS);
    glNormal3f(0,0,-1);
    glTexCoord3i(1,0,0);
    glVertex3f(  x,  -y,  -z);
    glTexCoord3i(0,0,0);
    glVertex3f( -x,  -y,  -z);
    glTexCoord3i(0,1,0);
    glVertex3f( -x,  y,  -z);
    glTexCoord3i(1,1,0);
    glVertex3f(  x,  y,  -z);
    glEnd();

    glBegin(GL_QUADS);
    glNormal3f(-1,0,0);
    glTexCoord3i(0,1,1);
    glVertex3f(  -x,  y,  z);
    glTexCoord3i(0,1,0);
    glVertex3f( -x,  y,  -z);
    glTexCoord3i(0,0,0);
    glVertex3f( -x,  -y,  -z);
    glTexCoord3i(0,0,1);
    glVertex3f(  -x,  -y,  z);
    glEnd();

    glBegin(GL_QUADS);
    glNormal3f(1,0,0);
    glTexCoord3i(1,1,0);
    glVertex3f(  x,  y,  -z);
    glTexCoord3i(1,1,1);
    glVertex3f( x,  y,  z);
    glTexCoord3i(1,0,1);
    glVertex3f( x,  -y,  z);
    glTexCoord3i(1,0,0);
    glVertex3f(  x,  -y,  -z);
    glEnd();

    shader->setUniformValue("volume", false);
    shader->setUniformValue("shaded", false);
    glLineWidth(2);
    if(true){
        glBegin(GL_LINES);
        glVertex3f(  x,  y, -z);
        glVertex3f(  x,  y, z);
        glVertex3f(  -x,  y, -z);
        glVertex3f(  -x,  y, z);
        glVertex3f(  x,  -y, -z);
        glVertex3f(  x,  -y, z);
        glVertex3f(  -x,  -y, -z);
        glVertex3f(  -x,  -y, z);

        glVertex3f(  x,  -y, z);
        glVertex3f(  x,  y, z);
        glVertex3f(  -x,  -y, z);
        glVertex3f(  -x,  y, z);
        glVertex3f(  x,  -y, -z);
        glVertex3f(  x,  y, -z);
        glVertex3f(  -x,  -y, -z);
        glVertex3f(  -x,  y, -z);

        glVertex3f(  -x,  y, z);
        glVertex3f(  x,  y, z);
        glVertex3f(  -x,  -y, z);
        glVertex3f(  x,  -y, z);
        glVertex3f(  -x,  y, -z);
        glVertex3f(  x,  y, -z);
        glVertex3f(  -x,  -y, -z);
        glVertex3f(  x,  -y, -z);
        glEnd();

    }
    shader->setUniformValue("shaded", true);

     glEnable(GL_DEPTH_TEST);
     glDisable( GL_BLEND );

    glPopMatrix();




}
