#ifndef SCENE_H
#define SCENE_H

#include <QObject>
#include <QtOpenGL>
#include <QGLFunctions>
#include <QOpenGLFunctions>

#include <scenenode.h>
#include <sceneobject.h>
#include <sceneprimitive.h>

class Scene: public QAbstractItemModel // QAbstractItemModel
{
    Q_OBJECT
public:
    Scene();
    ~Scene();
    void draw(QGLShaderProgram *shader);

    int simpleScene();


    void moveActive(QVector3D dir);
    void rotateActive(QQuaternion rot);

    void addSceneObjectTaActive(SceneObject *obj);
    SceneObject *getActive();
    SceneObject *setActive(int id);


    QVariant data(const QModelIndex &index, int role) const Q_DECL_OVERRIDE;
    QVariant headerData(int section, Qt::Orientation orientation,
                        int role = Qt::DisplayRole) const Q_DECL_OVERRIDE;

    QModelIndex index(int row, int column,
                      const QModelIndex &parent = QModelIndex()) const Q_DECL_OVERRIDE;
    QModelIndex parent(const QModelIndex &index) const Q_DECL_OVERRIDE;

    int rowCount(const QModelIndex &parent = QModelIndex()) const Q_DECL_OVERRIDE;
    int columnCount(const QModelIndex &parent = QModelIndex()) const Q_DECL_OVERRIDE;

     Qt::ItemFlags flags(const QModelIndex &index) const Q_DECL_OVERRIDE;

    int tesselation;

public slots:
    void objectSelected(QModelIndex index);
    void setTesselation(int tesselation);
    void addCube();
    void addSphere();
    void addCylinder();
    void addTorus();
    void addCone();
    void addNode();
    void deletActive();

signals:
    void activChanged();

private:
    SceneNode *root;
    SceneObject *active;
    QModelIndex activeIndex;
    SceneObject *getItem(const QModelIndex &index) const;


    SceneNode *getRoot();


};

#endif // SCENE_H
