uniform bool shaded;

varying vec4 pick;

varying vec3 position;
varying vec3 normal;

void main(void)
{
    vec3 N = normalize(normal);
    vec3 L = normalize(gl_LightSource[0].position.xyz-position);

    vec4 diffuse = vec4(max(dot(L,N),0.0));

    vec4 Iamb = gl_FrontLightProduct[0].ambient;
    vec4 Idiff = gl_FrontLightProduct[0].diffuse*diffuse;
    Idiff = clamp(Idiff, 0.0, 1.0);

    vec3 V = normalize(-position);


    vec3 R = normalize(reflect(-L,N));

    float specular = pow(max(dot(R,V),0.0),gl_FrontMaterial.shininess);//);
    vec4 Ispec = gl_FrontLightProduct[0].specular * specular;
    Ispec = clamp(Ispec, 0.0, 1.0);

    vec4 color = (
                Iamb
                + Idiff
                + Ispec
                );

    if(shaded)
        gl_FragData[0] =  color;
    else
        gl_FragData[0] = vec4(1,1,0,1);

    gl_FragData[1] = pick;
    gl_FragData[1] = vec4(abs(normal),1);
}
