#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMenu>
#include <QMenuBar>
#include <QAction>
#include <QActionGroup>
#include <QIcon>
#include <QMessageBox>
#include <QToolBar>
#include <QStatusBar>
#include <QSlider>

#include <cubewidget.h>


class MainWindow : public QMainWindow
{
    Q_OBJECT

private:
    QMenuBar *menuBar;

    QMenu *fileMenu;
    QAction *exitAction;

    QMenu *shadingMenu;
    QActionGroup *shadingGroup;
    QAction *noneAction;
    QAction *flatAction;
    QAction *gouraudAction;
    QAction *phongAction;

    QAction *aboutAction;

    QAction *camHome;

    QToolBar *toolBar;
    QStatusBar *statusBar;
    QSlider *slider;

    CubeWidget *mainWidget;


public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    void showAboutBox();
};

#endif // MAINWINDOW_H
