#include "mainwindow.h"



MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{

    setWindowTitle("Hello Cube");

    menuBar = new QMenuBar();
    toolBar = new QToolBar("Shading",this);
    statusBar = new QStatusBar(this);

    //Main Widget
    mainWidget = new CubeWidget(this);
    setCentralWidget(mainWidget);

    //File Menu Actions
    fileMenu = new QMenu("&File");
    shadingMenu= new QMenu("Shading");
    shadingGroup = new QActionGroup(shadingMenu);

    //Shader Menu Actions
    exitAction = new QAction("E&xit",fileMenu);
    exitAction->setShortcut(QKeySequence::Quit);
    connect(exitAction, SIGNAL(triggered()), this, SLOT(close()));

    noneAction = new QAction("None",shadingMenu);
    noneAction->setShortcut(QKeySequence("Ctrl+1"));
    noneAction->setCheckable(true);
    noneAction->setIcon(QIcon(":/img/wireframe.png"));
    connect(noneAction, SIGNAL(triggered()), mainWidget, SLOT(showWireframe()));
    shadingGroup->addAction(noneAction);

    flatAction = new QAction("Flat",shadingMenu);
    flatAction->setShortcut(QKeySequence("Ctrl+2"));
    flatAction->setCheckable(true);
    flatAction->setChecked(true);
    flatAction->setIcon(QIcon(":/img/flat.png"));
    connect(flatAction, SIGNAL(triggered()), mainWidget, SLOT(showFlat()));
    shadingGroup->addAction(flatAction);

    gouraudAction = new QAction("Gouraud",shadingMenu);
    gouraudAction->setShortcut(QKeySequence("Ctrl+3"));
    gouraudAction->setCheckable(true);
    gouraudAction->setIcon(QIcon(":/img/gouraud.png"));
    connect(gouraudAction, SIGNAL(triggered()), mainWidget, SLOT(showGouraut()));
    shadingGroup->addAction(gouraudAction);

    phongAction = new QAction("Phong",shadingMenu);
    phongAction->setShortcut(QKeySequence("Ctrl+4" ));
    phongAction->setCheckable(true);
    phongAction->setIcon(QIcon(":/img/phong.png"));
    connect(phongAction, SIGNAL(triggered()), mainWidget, SLOT(showPhong()));
    shadingGroup->addAction(phongAction);

    //Other Actions
    aboutAction = new QAction("About",menuBar);
    connect(aboutAction,SIGNAL(triggered()),this,SLOT(showAboutBox()));

    camHome = new QAction(QIcon(":/img/cam_home.png"),"Cam Home", toolBar);
    connect(camHome, SIGNAL(triggered(bool)),mainWidget,SLOT(home()));

    slider = new QSlider(Qt::Horizontal,toolBar);
    slider->setMinimum( 0 );
    slider->setMaximum( 4 );
    slider->setValue( 0 );
    connect(slider,SIGNAL(valueChanged(int)),mainWidget,SLOT(setTessellation(int)));
   // slider->setSizePolicy();

    // Assemble Menus
    fileMenu->addAction(exitAction);
    menuBar->addMenu(fileMenu);

    shadingMenu->addAction(noneAction);
    shadingMenu->addAction(flatAction);
    shadingMenu->addAction(gouraudAction);
    shadingMenu->addAction(phongAction);
    menuBar->addMenu(shadingMenu);

    menuBar->addAction(aboutAction);

    setMenuBar(menuBar);

    //Assemble Tool Bar
    toolBar->addAction(noneAction);
    toolBar->addAction(flatAction);
    toolBar->addAction(gouraudAction);
    toolBar->addAction(phongAction);
    toolBar->addWidget(slider);
    toolBar->addAction(camHome);
    addToolBar( toolBar);

    statusBar->showMessage("Hello");
    setStatusBar(statusBar);





}

MainWindow::~MainWindow()
{

}

void MainWindow::showAboutBox()
{
 QMessageBox msgBox;
 msgBox.setWindowTitle("About Hello Cube!");
 msgBox.setText("Written by Kai Westerkamp");
 msgBox.exec();
}
