#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <QObject>
#include <QtOpenGL>
#include <QOpenGLWidget>
#include <QOpenGLFunctions_4_3_Core>
#include <QOpenGLShaderProgram>
#include <assimp/Importer.hpp>
#include <assimp/scene.h>
#include <assimp/postprocess.h>
#include "mesh.h"


class MainWidget : public QOpenGLWidget, public QOpenGLFunctions_4_3_Core
{
    Q_OBJECT
public:
    MainWidget();

    QSize minimumSizeHint() const;
    QSize sizeHint() const;

public slots:
    void loadNewMesh();

protected:
        void initializeGL();
        void paintGL();
        void resizeGL(int width, int height);
        void wheelEvent(QWheelEvent *event ) ;

private:

        QOpenGLShaderProgram* animationShader;
        QMatrix4x4 m_projection;
        QMatrix4x4 m_view;

        float camDistance;

        Mesh *mesh;

        QOpenGLShaderProgram* initShader(QString fragSource, QString vertSource);
};

#endif // MAINWIDGET_H
