#version 330
layout(location = 0) in vec3 Position;
layout(location = 1) in vec3 Normal;
layout(location = 2) in vec2 UV;
layout(location = 2) in ivec4 BoneIDs;
layout(location = 2) in vec4 Weights;


out vec3 vCamPosition;
out vec3 vCamNormal;
out vec2 vUV;

uniform mat4x4 MV;
uniform mat4x4 MVP;
uniform mat3x3 N;


void main(void)
{
    vCamPosition = vec4(MV*vec4(Position,1.0)).xyz;
    vCamNormal = N*Normal;
    vUV = UV;


    gl_Position = MVP * vec4(Position,1.0);


}

