#include "sceneobject.h"
#include "scenenode.h"


int SceneObject::idCount = 1;

SceneObject::SceneObject()
{
    id = idCount;
    idCount++;
    name = QString("Scene Object "+id);
    rotation = QQuaternion();
    translation = QVector3D();
    parent = NULL;
}


SceneObject *SceneObject::getParent()
{
    return parent;
}

SceneObject *SceneObject::children(int /* number*/)
{
    return NULL;
}

int SceneObject::childCount() const
{
    return 0;
}

int SceneObject::childNumber() const
{
    if (parent){
        SceneNode* node = static_cast<SceneNode*>(parent);
        return node->getChildren().indexOf(const_cast<SceneObject*>(this));
    }
     return 0;
}

int SceneObject::columnCount() const
{
    return 1+itemData.count();
}

QVariant SceneObject::data(int column) const
{
    if(column == 0) return name;

    return itemData.value(column);
}

bool SceneObject::setData(int column, const QVariant &value)
{
     qDebug()<<"Set Data called";
    if (column < 0 || column >= itemData.size())
        return false;

    if(column == 0) setName(value.toString());
    else itemData[column] = value;
    return true;
}





int SceneObject::getID(){return id;}

QString SceneObject::getName(){return name;}

QQuaternion SceneObject::getGlobalRotation(){
    if(parent == NULL)
        return QQuaternion();
    else
        return parent->getGlobalRotation() *rotation;
}


void SceneObject::move(QVector3D dir)
{
    QQuaternion rot = parent->getGlobalRotation();
    translation+=rot.conjugate().rotatedVector(dir);
}

void SceneObject::rotate(QQuaternion rot)
{

    rotation = rot * rotation;


}

void SceneObject::draw(QGLShaderProgram *shader){qDebug()<<"Drawing abstract Scene Element";}

SceneObject *SceneObject::find(int id)
{
   if(this->id == id){
       return this;
   } else{
       return NULL;
   }

}


 void SceneObject::applyTransformation()
 {
     QMatrix4x4 mat = QMatrix4x4();
     mat.translate(translation);
     glMultMatrixf(mat.data());

     mat = QMatrix4x4();
     mat.rotate(rotation);
     glMultMatrixf(mat.data());
 }
