#ifndef SCENENODE_H
#define SCENENODE_H

#include <sceneobject.h>
#include <QList>

class SceneNode : public SceneObject
{
    Q_OBJECT
private:
    QList<SceneObject*> childs;

public:
    SceneNode();
    ~SceneNode();
    SceneObject *children(int number);
    int childCount() const;
    QList<SceneObject*> getChildren(){return childs;}


    virtual bool isNode(){return true;qDebug()<<"isNode";}

    SceneObject *find(int id);
    void draw(QGLShaderProgram *shader);
    void add(SceneObject *child);
    void remove(int number);

};

#endif // SCENENODE_H
