#version 420
out vec4 FragColor;

in vec3 gPosition;
in vec2 gUV;
in vec3 gTriDistance;
in vec2 gPatchDistance;
in float tesselationLevel;

uniform sampler2D heightmap;
uniform sampler2D landTex1;
uniform sampler2D landTex2;

uniform bool wireframe;

uniform float heightFactor;

void main()
{
    //

    vec2 textureUV = gUV*8;
    vec3 col1 = texture2D(landTex1,textureUV).xyz;
    vec3 col2 = texture2D(landTex2,textureUV).xyz;

    float height = clamp(gPosition.y/heightFactor*15,0.0,1.0);
    float alpha = smoothstep(0.5f,0.7f,height);


    FragColor = +vec4((1-alpha)*col2  + alpha *col1,1.0);

    //  FragColor = clamp(vec4(vec3(textureLod(heightmap,gUV,5-tesselationLevel).x), 1.0)*10,0,1);
    //FragColor = vec4(gUV,0.0,1.0);
    //FragColor = vec4(height);

    if(wireframe == true){
        float d = min(gTriDistance.x,min(gTriDistance.y,gTriDistance.z));
        if(d < 0.05){
            FragColor = vec4(0.0,1.0,0.0,1.0);
        }

        float d2 = min(gPatchDistance.x,min(gPatchDistance.y,1-max(gPatchDistance.x,gPatchDistance.y)));
        if(d2 < 0.01){
            FragColor = vec4(0.0,0.0,1.0,1.0);
        }
    }
}
