#ifndef GLVIEW_H
#define GLVIEW_H

#include <QtGui>
#include <QtOpenGL>

#include <controler.h>
#include <camera.h>
#include <scene.h>
#include <gl/GLU.h>
#include <QGLFunctions>
#include <QOpenGLFunctions_4_0_Core>
#include <math.h>

class GLView : public QGLWidget, public QOpenGLFunctions_4_0_Core
{
    Q_OBJECT
protected :
    void initializeGL ( ) ;
    void paintGL ( ) ;
    void resizeGL(int width , int height ) ;
    void mousePressEvent(QMouseEvent *event ) ;
    void mouseMoveEvent(QMouseEvent *event ) ;
    void wheelEvent(QWheelEvent *event ) ;
    void keyPressEvent(QKeyEvent* event);


public slots:
    void home();
    void setGridSize(int size){gridSize = size;}
    void setGridStepSize(int size){gridStepSize = size;}
    void showGrid(bool bo){isGridEnabled = bo;}
    void loadData(int width, int height, int depth, char* data, int type);
    void setLandscape(int width,int height,int max,boolean shortNeeded,char* data);
    void setLandscapeTexture(int number, QImage *texture);
    void loadTransfer(uchar* data);
    void setMIP(bool mip);


public:
    GLView(Scene *scene,Camera * camera,Controler *controler,QGLFormat format );
    void setHome(QQuaternion *rotation, QVector3D *translation);


    QSize minimumSizeHint() const;
    QSize sizeHint() const;


    void setAcive(bool active);
    Camera *getCamera();

private:
    bool afterInit;
    QGLShaderProgram *shader;
    QGLShaderProgram *displayShader;
    QOpenGLShaderProgram *landscapeShader;
    Scene *scene;

    Controler *controler;
    Camera *camera;

    bool isActive;

    GLdouble aspect;

    GLuint fbo;
    GLuint color;
    GLuint picID;
    GLuint depth;

    GLuint startRay;
    GLuint stopRay;



    GLuint texture3D;
    GLuint transferFunction;
    bool MIP;

    bool wireframe;
    int IndexCount;
    bool landscape;
    GLuint heightmap;
    GLuint vertexArray;
    GLuint indices;

    GLuint landscapeTexture1;
    GLuint landscapeTexture2;



    void drawGrid();
    void initShader();

    float gridStepSize;
    float gridSize;
    bool isGridEnabled;
};

#endif // GLVIEW_H
