#ifndef CONTROLER_H
#define CONTROLER_H

#include <QObject>
#include <QtGui>
#include <QImage>

class camera;
class GLView;
class Scene;
class MainWindow;

enum Mode{CAMERA, EDIT};

class Controler: public QObject
{
     Q_OBJECT
public:
    Controler(MainWindow *mainwindow,Scene *scene);

    void mousePressed(GLView* view, QMouseEvent *event);
    void mouseMoveEvent(GLView* view, QMouseEvent *event);
    void wheelEvent(GLView* view, QWheelEvent *event );

public slots:
    void setCamMode();
    void setEditMode();

    void addVolume();
    void addVolume(QString filePath);

    void addLandscape();
    void addLandscape(QString filePath);

    QImage *loadImage(QString Text);

private:
    MainWindow *mainwindow;
    Scene *scene;
    GLView *activeView;

    QVector3D *lastSpeherePos;
    QPointF * lastScreenPos;

    Mode viewMode;



    QVector3D* trackballPoint(int x, int y);
    void rotate(QVector3D *newPos );
    void move(QPointF * newPos);
};

#endif // CONTROLER_H
