#ifndef TRANSFERFUNCTIONEDITOR_H
#define TRANSFERFUNCTIONEDITOR_H

#include <QWidget>
#include <QPainter>
#include <QDebug>
#include <QFileDialog>
#include <QtGui>
#include <QObject>
#include <QMessageBox>

class TransferFunctionEditor : public QWidget
{
    Q_OBJECT

public:
    TransferFunctionEditor(QWidget *parent = 0);
    ~TransferFunctionEditor();

    void setHistogram(int *histogram);
    void setTransferFunction(uchar *trans);
    uchar* getTransferFunctin();

     void mousePressEvent(QMouseEvent *event ) ;

public slots:
    void paintRed(bool paint);
    void paintGreen(bool paint);
    void paintBlue(bool paint);
    void paintAlpha(bool paint);

    void save();
    void load();
    void reset();
    void smooth();

signals:
    void dataChanged(uchar* function);

protected:
    void paintEvent(QPaintEvent *event);

private:
    uchar *trans;
    int *histogram;

    int histoMax;

    bool red;
    bool green;
    bool blue;
    bool alpha;

    int temp = 0;
};

#endif // TRANSFERFUNCTIONEDITOR_H
