#ifndef SCENEPRIMITIVE_H
#define SCENEPRIMITIVE_H

#include <sceneobject.h>
#include <glut.h>

enum PrimitiveType{Quader=0,Sphere,Cylinder,Torus,Cone};

class ScenePrimitive : public SceneObject
{
   Q_OBJECT
private:
    static int quaderCount;
    static int sphereCount;
    static int cylinderCount ;
    static int torusCount;
     static int coneCount;

    PrimitiveType type;
    int tesselation;
    GLUquadric *qobj;
    float *color;

    void drawCube(int tesselation);

public:


    void draw(QGLShaderProgram *shader);


    void setMaterial(float *color);
    ScenePrimitive(PrimitiveType type, int tesselation);
};

#endif // SCENEPRIMITIVE_H
