#ifndef SCENEOBJECT_H
#define SCENEOBJECT_H

#include <QObject>
#include <QQuaternion>
#include <QVector3D>
#include <QVector>
#include <QtOpenGL>
#include <gl/GLU.h>

class SceneObject : public QObject
{
    Q_OBJECT

    static int idCount;
protected:
    QQuaternion rotation;
    QVector3D translation;
    int id;
    QString name;
    void applyTransformation();

    QVector<QVariant> itemData;

    SceneObject *parent;

public:
    SceneObject();

    void setParent(SceneObject *parent){this->parent = parent;}
    SceneObject *getParent();
    virtual SceneObject *children(int number);

    virtual bool isNode(){return false;}

    int childNumber() const;
    virtual int childCount() const;
    int columnCount() const;
    QVariant data(int column) const;
    bool setData(int column, const QVariant &value);

    virtual void draw(QGLShaderProgram *shader);
    virtual SceneObject *find(int id);
    int getID();
    QString getName();
    void setName(QString name){this->name = name;}
    void move(QVector3D dir);
    void rotate(QQuaternion rot);

    QQuaternion getGlobalRotation();

};

#endif // SCENEOBJECT_H
