#include "scenenode.h"




SceneNode::SceneNode()
    :SceneObject()
{
    childs = QList<SceneObject*>();
}

SceneNode::~SceneNode()
{
    qDeleteAll(childs);
}


SceneObject *SceneNode::children(int number)
{
    return childs.value(number);
}

int SceneNode::childCount() const
{
    return childs.count();
}



void SceneNode::add(SceneObject *child)
{
    childs.append(child);
}

 void SceneNode::remove(int number)
 {
     delete childs.takeAt(number);
 }

SceneObject *SceneNode::find(int id)
{
    foreach (SceneObject *obj, childs) {
        SceneObject *temp = obj->find(id);
        if(temp != NULL)
            return temp;
    }

    return NULL;

}


void SceneNode::draw(QGLShaderProgram *shader)
{
    glPushMatrix();
    applyTransformation();
    foreach (SceneObject *obj, childs) {
        obj->draw(shader);
    }

    glPopMatrix();
}
