#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMenu>
#include <QMenuBar>
#include <QAction>
#include <QActionGroup>
#include <QIcon>
#include <QMessageBox>
#include <QToolBar>
#include <QStatusBar>
#include <QSlider>
#include <QSplitter>
#include <QPushButton>

#include <glview.h>
#include <scene.h>
#include <camera.h>
#include <controler.h>
#include <transferfunctioneditor.h>

class MainWindow : public QMainWindow
{
    Q_OBJECT

private:
    QMenuBar *menuBar;

    QMenu *fileMenu;
    QAction *exitAction;

    QMenu *interactionMenu;
    QActionGroup *interactionGroup;
    QAction *cameraMode;
    QAction *editMode;

    QMenu *viewMenu;
    QActionGroup *viewGoup;
    QAction *singleView;
    QAction *dualView;
    QAction *quadView;

    QAction *aboutAction;

    QAction *camHome;

    QMenu *primitivesMenu;
    QAction *spheresAdd;
    QAction *boxesAdd;
    QAction *cylindersAdd;
    QAction *coneAdd;
    QAction *torusAdd;
    QAction *groupAdd;
    QAction *activeDelete;
    QAction *volumeAdd;


    QToolBar *toolBar;
    QStatusBar *statusBar;
    QSlider *slider;

    Scene* scene;
    Controler *controler;

    QSplitter *topSplit;
    QSplitter *bottomSplit;
    QSplitter *verticalSplit;

    GLView *perspectiveView;
    GLView *frontView;
    GLView *leftView;
    GLView *topView;
    GLView **views;

    QTreeView *sceneView;

    QSpinBox* gridSizeInput;
    QSpinBox* gridStepInput;
    QToolButton* showGridButton;

     QToolButton* MIPButton;

    QTimer *timer;



    void initDoc();

    void initViews();

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void setActiveView(GLView * active);

    GLView** getViews();

    void initSplits();

    void initToolbar();

    void initGrid();

    void initPrimitivesMenu();


    TransferFunctionEditor *transEditor;

public slots:
    void updateGL();
    void updateStatusBar();
    void showAboutBox();
    void showSingle();
    void showDual();
    void showQuad();
     void initScene();
};

#endif // MAINWINDOW_H
