#ifndef GLVIEW_H
#define GLVIEW_H

#include <QtGui>
#include <QtOpenGL>

#include <controler.h>
#include <camera.h>
#include <scene.h>
#include <gl/GLU.h>
#include <QGLFunctions>
#include <QOpenGLFunctions_4_3_Core>

class GLView : public QGLWidget, public QOpenGLFunctions_4_3_Core
{
    Q_OBJECT
protected :
    void initializeGL ( ) ;
    void paintGL ( ) ;
    void resizeGL(int width , int height ) ;
    void mousePressEvent(QMouseEvent *event ) ;
    void mouseMoveEvent(QMouseEvent *event ) ;
    void wheelEvent(QWheelEvent *event ) ;

public slots:
    void home();
    void setGridSize(int size){gridSize = size;}
    void setGridStepSize(int size){gridStepSize = size;}
    void showGrid(bool bo){isGridEnabled = bo;}
    void loadData(int width, int height, int depth, char* data, int type);
    void loadTransfer(uchar* data);
    void setMIP(bool mip);

public:
    GLView(Scene *scene,Camera * camera,Controler *controler );
    void setHome(QQuaternion *rotation, QVector3D *translation);


    QSize minimumSizeHint() const;
    QSize sizeHint() const;


    void setAcive(bool active);
    Camera *getCamera();

private:
    bool afterInit;
    QGLShaderProgram *shader;
    QGLShaderProgram *displayShader;
    Scene *scene;

    Controler *controler;
    Camera *camera;

    bool isActive;

    GLdouble aspect;

    GLuint fbo;
    GLuint color;
    GLuint picID;
    GLuint depth;

    GLuint startRay;
    GLuint stopRay;

    GLuint texture3D;
    GLuint transferFunction;
     bool MIP;


    void drawGrid();
    void initShader();

    float gridStepSize;
    float gridSize;
    bool isGridEnabled;
};

#endif // GLVIEW_H
