#ifndef CUBEWIDGET_H
#define CUBEWIDGET_H

#include <QtGui>
#include <QtOpenGL>
#include <QGLFunctions>
#include <QOpenGLFunctions>
#include <math.h>
#include <QMatrix4x4>
#include <QQuaternion>
#include <QVector3D>
#include <algorithm>



class CubeWidget : public QGLWidget
{
    Q_OBJECT
protected :
    void initializeGL ( ) ;
    void paintGL ( ) ;
    void resizeGL(int width , int height ) ;
    void mousePressEvent(QMouseEvent *event ) ;
    void mouseMoveEvent(QMouseEvent *event ) ;
    void wheelEvent(QWheelEvent *event ) ;

public:
    CubeWidget(QWidget *parent = 0);

    QSize minimumSizeHint() const;
    QSize sizeHint() const;

public slots:
    void showWireframe();
    void showFlat();
    void showGouraut();
    void showPhong();
    void home();

    void setTessellation(int t );

private:
    int tesselation;
    int zoom;

    QVector3D *lastSpeherePos;
    QPointF * lastScreenPos;

    QQuaternion *rotation;
    QMatrix4x4 * translation;

    QGLShaderProgram *shader;

    void prepareShader();

    void perspective(GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar);
    void setMaterial(GLfloat *color );
    void rotate(QVector3D *newPos );
    void move(QPointF *newPos );
    QVector3D *trackballPoint(int x, int y);
};

#endif // CUBEWIDGET_H
