#ifndef CAMERA_H
#define CAMERA_H


#include <QtGui>
#include <QtOpenGL>

#include <QQuaternion>
#include <QVector3D>

class Camera: public QObject
{
     Q_OBJECT
private:
    bool persp;
//    QQuaternion *rotation;
//    QVector3D *translation;

    QQuaternion *homeRotation;
    QVector3D *homeTranslation;

    void perspective(GLdouble fovy, GLdouble aspect, GLdouble zNear, GLdouble zFar);

public slots:
    void home();

public:
    QQuaternion *rotation;
    QVector3D *translation;

    Camera(bool persp);
    void setHome(QQuaternion *rotation, QVector3D *translation);
    void rotate(QQuaternion newPos );
    void move(QVector3D newPos );

    void setupCamera(GLdouble aspect);
};

#endif // CAMERA_H
