#include "treedelegate.h"
#include <QDebug>
#include <QLineEdit>
#include <QString>
#include <scene.h>

TreeDelegate::TreeDelegate()
{

}

void TreeDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                const QModelIndex &index) const
{
    qDebug()<<"out";
    QLineEdit *lineEdit = qobject_cast<QLineEdit *>(editor);
    if (!lineEdit->isModified()) {
        return;
    }
    QString text = lineEdit->text();
    text = text.trimmed();
    if (text.isEmpty()) {
        // If text is empty, do nothing - preserve the old value.
        return;
    } else {
        if (index.isValid()) {
            SceneObject *item = static_cast<SceneObject*>(index.internalPointer());
            if (item)
                item->setName(text);
        }
        emit nameChanged();
    }
}

