﻿using UnityEngine;
using System.Collections;

public class Turret : MonoBehaviour
{

  public GameObject rocketPrefab;
  private Transform target;
  private Rocket currentRocket;


  // Update is called once per frame
  void Update()
  {
    if (!target) return;

    Vector3 direction = target.position - transform.position;
    transform.rotation = Quaternion.Euler(0, 0, -Mathf.Rad2Deg * Mathf.Atan2(direction.x, direction.y));
  }

  public void setTarget(Transform newTarget)
  {
    target = newTarget;
  }

  public void shoot()
  {
    if (currentRocket) return; // do not shoot another rocket when there is one already flying.

    currentRocket = (GameObject.Instantiate(rocketPrefab, transform.position, transform.rotation) as GameObject).GetComponent<Rocket>();
    currentRocket.setTarget(target);
  }
}
