﻿using UnityEngine;
using System.Collections;

public class Trap : MonoBehaviour
{

  public int damagePoints = 10;
  public float respawnTime = 5.0f;

  // used to store the position while the trap is deactivated
  private Vector2 realPosition;

  public GameObject hitEffectPrefab;
  private Animator hitEffect;

  void Start()
  {
    hitEffect = (GameObject.Instantiate(hitEffectPrefab, transform.position, transform.rotation) as GameObject).GetComponent<Animator>();
  }

  void OnTriggerEnter2D(Collider2D other)
  {
    if (other.tag == "Player")
    {
      other.GetComponent<PlayerHealth>().changeHealthBy(-damagePoints);
      hitEffect.SetTrigger("play"); //play animation.
      destroyTrap();
    }
  }

  public void destroyTrap()
  {
    realPosition = transform.position;
    transform.position = new Vector2(100, 100);
    Invoke("Activate", respawnTime);
  }

  void Activate()
  {
    transform.position = realPosition;
  }
}
