﻿using UnityEngine;
using System.Collections;

public class ShieldScript : MonoBehaviour
{

  PlayerHealth parentHealth;

  public float shieldingTime = 10;

  // Use this for initialization
  void Start()
  {
    Invoke("stopShielding", shieldingTime);
  }

  void OnTriggerEnter2D(Collider2D other)
  {
    PlayerHealth oldHealth = parentHealth;
    if (other.tag == "Player")
    {
      parentHealth = other.GetComponent<PlayerHealth>();
      transform.position = other.transform.position; //hier schon position setzen
      transform.parent = other.transform;
      Debug.Log("Set shield from shield");
      parentHealth.setShield(true);
    }
    if (oldHealth != null && oldHealth != parentHealth) oldHealth.setShield(false);

  }

  void stopShielding()
  {
    if (parentHealth != null) parentHealth.setShield(false);
    Destroy(gameObject);
  }
}
