﻿using UnityEngine;
using System.Collections;

public class Rocket : MonoBehaviour
{

  #region members
  public int damagePoints = 15;
  public float flyToTargetSpeed = 10f;
  public float speed = 1f;
  public float pushForce = 20f; //wie stark das target weggeschubst wird beim aufprall.

  private Rigidbody2D body;
  public Transform target;
  public Animator explosionAnimator;
  private GameObject explosion;
  #endregion

  // Use this for initialization
  void Start()
  {
    body = GetComponent<Rigidbody2D>();
  }

  // Update is called once per frame
  void Update()
  {
    if (!target) return;

    //update direction:
    Vector3 direction = target.position - transform.position;
    body.velocity = Vector2.Lerp(body.velocity, (float)speed * direction.normalized, Time.deltaTime * flyToTargetSpeed);
    Quaternion newRotation = Quaternion.Euler(0, 0, -Mathf.Rad2Deg * Mathf.Atan2(direction.x, direction.y));
    transform.rotation = Quaternion.Slerp(transform.rotation, newRotation, Time.deltaTime * flyToTargetSpeed);
  }

  void OnTriggerEnter2D(Collider2D other)
  {
    if (other.tag == "Player")
    {
      other.GetComponent<PlayerHealth>().changeHealthBy(-damagePoints);
      Rigidbody2D otherBody = other.GetComponent<Rigidbody2D>();
      Debug.Log(body.velocity.normalized * pushForce);
      otherBody.velocity = Vector2.zero;
      otherBody.AddForce(body.velocity.normalized * pushForce);

      //explosion effect:
      explosion = GameObject.Instantiate(explosionAnimator.gameObject, transform.position, transform.rotation) as GameObject;

      gameObject.GetComponent<SpriteRenderer>().enabled = false;
      gameObject.GetComponent<Collider2D>().enabled = false;

      Invoke("destroy", 1.0f);
    }
  }


  void destroy()
  {
    Destroy(explosion);
    Destroy(gameObject);
  }

  public void setTarget(Transform newTarget)
  {
    target = newTarget;
  }
}
